<?php
    $course = App\Models\Course::where('id', $id)->first();

    $selected_lesson = 'youtube';
    if (isset($param3) && !empty($param3)) {
        $selected_lesson = $param3;
    }
?>

<div class="alert alert-primary ol-alert-primary ol-alert-sm mb-3" role="alert">
    <p class="title2 fs-14px"><?php echo e(get_phrase('Course')); ?>:
        <span class="title"><?php echo e($course->title); ?></span>
    </p>
</div>

<form action="">
    <input id="course_id_for_lesson" type="hidden" value="" name="course_id_for_lesson">
    <div class="ol-modal-form">
        <h6 class="title fs-16px mb-3"><?php echo e(get_phrase('Select lesson type')); ?></h6>
        <div class="row row-12px row-cols-1 row-cols-sm-2 mb-20px">
            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-youtube">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/video-square-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('YouTube Video')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-youtube" value="youtube" <?php if($selected_lesson == 'youtube'): ?> checked <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-vimeo">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/video-circle-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Vimeo Video')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-vimeo" value="vimeo" <?php if($selected_lesson == 'vimeo'): ?> checked <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-videofile">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/video-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Video file')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-videofile" value="video" <?php if($selected_lesson == 'video'): ?> checked <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-url">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/link-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Video url [ .mp4 ]')); ?></p>
                    </div>
                    <input value="html5" class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-url">
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-drive">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/document-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Google drive video')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-drive" value="google_drive_video"
                        <?php if($selected_lesson == 'google_drive_video'): ?> <?php echo e(get_phrase('checked')); ?> <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-document">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/document-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Document file')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-document" value="document" <?php if($selected_lesson == 'document'): ?> checked <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-text">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/text-block-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Text')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-text" value="text"
                        <?php if($selected_lesson == 'text'): ?> <?php echo e(get_phrase('checked')); ?> <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-image">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/volume-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Image')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-image" value="image"
                        <?php if($selected_lesson == 'image'): ?> <?php echo e(get_phrase('checked')); ?> <?php endif; ?>>
                </label>
            </div>


            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-iframe">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/volume-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Iframe embed')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-iframe" value="iframe"
                        <?php if($selected_lesson == 'iframe'): ?> <?php echo e(get_phrase('checked')); ?> <?php endif; ?>>
                </label>
            </div>

            <div class="col">
                <label class="ol-radiobox-1 d-flex align-items-center justify-content-between flex-wrap"
                    for="radio-scorm">
                    <div class="title-icon d-flex align-items-center">
                        <img src="assets/images/icons/volume-black-18.svg" alt="">
                        <p class="title"><?php echo e(get_phrase('Scorm Content')); ?></p>
                    </div>
                    <input class="form-check-input form-check-input-radio" type="radio" name="lesson_type"
                        id="radio-scorm" value="scorm"
                        <?php if($selected_lesson == 'scorm'): ?> <?php echo e(get_phrase('checked')); ?> <?php endif; ?>>
                </label>
            </div>

        </div>
        
        <div class="mt-3">
            <a href="javascript:void(0)" type="button" class="btn btn-primary" data-toggle="modal"
                data-dismiss="modal" id="lesson-add-modal" onclick="showLessonAddModal()"><?php echo e(get_phrase('Next')); ?>

                <i class="fi-rr-angle-small-right"></i> </a>
        </div>
    </div>
</form>

<script type="text/javascript">
    "use strict";

    function showLessonAddModal() {
        var url = $("input[name=lesson_type]:checked").val();
        ajaxModal('<?php echo e(route('modal', ['admin.course.lesson_add', 'id' => $course->id])); ?>&lesson_type=' + url,
            '<?php echo e(get_phrase('Add new lesson')); ?>')
    }
</script>
<?php /**PATH /home/ttelbdtex/public_html/resources/views/admin/course/lesson_type.blade.php ENDPATH**/ ?>