<?php $__env->startPush('title', get_phrase('About')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $curl_enabled = function_exists('curl_version');
    ?>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('About This Application')); ?>

                </h4>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-xl-7">
            <div class="ol-card p-4">
                <p class="title text-14px mb-3"><?php echo e(get_phrase('About this application')); ?></p>
                <div class="ol-card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="media align-items-center">
                                <div class="media-body">
                                    <div class="table-responsive">
                                        <table class="table eTable">
                                            <div class="chart-widget-list">
                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Software version')); ?>

                                                    <span class="ms-auto float-end ml-5"><?php echo e(get_settings('version')); ?></span>
                                                </p>
                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Laravel version')); ?>

                                                    <span class="ms-auto float-end ml-5">11.10.0</span>
                                                </p>
                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Check update')); ?>

                                                    <span class="ms-auto float-end">
                                                        <a href="https://codecanyon.net/user/creativeitem/portfolio" target="_blank">
                                                            <i class="bi bi-telegram"></i>
                                                            <?php echo e(get_phrase('Check update')); ?>

                                                        </a>
                                                    </span>
                                                </p>
                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Php version')); ?>

                                                    <span class="ms-auto float-end"><?php echo e(phpversion()); ?></span>
                                                </p>
                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Curl enable')); ?>

                                                    <span class="ms-auto float-end">
                                                        <?php
                                                            echo $curl_enabled ? '<span class="eBadge ebg-soft-success">' . get_phrase('Enabled') . '</span>' : '<span class="eBadge ebg-soft-danger">' . get_phrase('Disabled') . '</span>';
                                                        ?>
                                                    </span>
                                                </p>
                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Fileinfo extension')); ?>


                                                    <?php if(extension_loaded('fileinfo')): ?>
                                                        <span class="badge bg-success ms-auto float-end">
                                                            <?php echo e(get_phrase('Enabled')); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger  ms-auto float-end"><?php echo e(get_phrase('Enable this Fileinfo extension on your server to upload files')); ?></span>
                                                        <span class="badge bg-danger ms-auto float-end">
                                                            <?php echo e(get_phrase('Disabled')); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </p>

                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Purchase code')); ?>

                                                    <span class="ms-auto float-end"><?php echo e(get_settings('purchase_code')); ?></span>
                                                </p>

                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Product license')); ?>

                                                    <?php if($application_details['product_license'] == 'valid'): ?>
                                                        <span class="ms-auto float-end badge bg-success text-capitalize"><?php echo e($application_details['product_license']); ?></span>
                                                    <?php else: ?>
                                                        <span class="ms-auto float-end badge bg-danger mt-1 text-capitalize"><?php echo e($application_details['product_license']); ?></span>
                                                        <button class="btn custom_btns ol-btn-primary float-end ms-2 me-2 py-0 text-13px" onclick="ajaxModal('<?php echo e(route('modal', ['admin.setting.save_purchase_code', 'action_type' => 'show'])); ?>', '<?php echo e(get_phrase('Enter valid purchase code')); ?>')"><?php echo e(get_phrase('Enter valid purchase code')); ?></button>
                                                    <?php endif; ?>
                                                </p>


                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Customer support status')); ?>

                                                    <span class="ms-auto float-end">
                                                        <?php if(strtolower($application_details['purchase_code_status']) == 'expired'): ?>
                                                            <span class="badge bg-danger float-end mt-1 text-capitalize"><?php echo e($application_details['purchase_code_status']); ?></span>
                                                            <a href="https://codecanyon.net/user/creativeitem/portfolio" target="_blank" class="btn btn-success float-end me-2 py-0 text-13px"><?php echo e(get_phrase('Renew support')); ?></a>
                                                        <?php elseif(strtolower($application_details['purchase_code_status']) == 'valid'): ?>
                                                            <span class="badge bg-success text-capitalize"><?php echo e($application_details['purchase_code_status']); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge bg-danger text-capitalize"><?php echo e($application_details['purchase_code_status']); ?></span>
                                                        <?php endif; ?>
                                                    </span>
                                                </p>

                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Support expiry date')); ?>


                                                    <?php if($application_details['support_expiry_date'] != 'invalid'): ?>
                                                        <span class="ms-auto float-end"><?php echo e($application_details['support_expiry_date']); ?></span>
                                                    <?php else: ?>
                                                        <span class="ms-auto float-end"><span class="badge bg-danger"><?php echo e(ucfirst($application_details['support_expiry_date'])); ?></span></span>
                                                    <?php endif; ?>
                                                </p>

                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Customer name')); ?>

                                                    <?php if($application_details['customer_name'] != 'invalid'): ?>
                                                        <span class="ms-auto float-end"><?php echo e($application_details['customer_name']); ?></span>
                                                    <?php else: ?>
                                                        <span class="ms-auto float-end"><span class="badge bg-danger"><?php echo e(ucfirst($application_details['customer_name'])); ?></span></span>
                                                    <?php endif; ?>
                                                </p>

                                                <p class="border-bottom mb-2 pb-2 text-13px d-flex align-items-center">
                                                    <i class="fi-rr-hand-back-point-right me-3"></i>
                                                    <?php echo e(get_phrase('Get customer support')); ?>

                                                    <span class="ms-auto float-end"><a class="about-sc-one" href="http://support.creativeitem.com" target="_blank"> <i class="bi bi-telegram"></i>
                                                            <?php echo e(get_phrase('Customer support')); ?>

                                                            <i class="fi-rr-navigation"></i>
                                                        </a> </span>
                                                </p>

                                            </div>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ttelbdtex/public_html/resources/views/admin/setting/about.blade.php ENDPATH**/ ?>