<?php $__env->startPush('title', get_phrase('Student')); ?>
<?php $__env->startPush('meta'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Student List')); ?>

                </h4>

                <a href="<?php echo e(route('admin.student.create')); ?>" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Add new Student')); ?></span>
                </a>
            </div>
        </div>
    </div>
    <div class="ol-card p-4">
        <div class="ol-card-body">

            <div class="row print-d-none mb-3 mt-3 row-gap-3">
                <div class="col-md-6  pt-2 pt-md-0">
                    <div class="custom-dropdown">
                        <button class="dropdown-header btn ol-btn-light">
                            <?php echo e(get_phrase('Export')); ?>

                            <i class="fi-rr-file-export ms-2"></i>
                        </button>
                        <ul class="dropdown-list">
                            <li>
                                <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'student-list')"><i class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <form class="form-inline" action="<?php echo e(route('admin.student.index')); ?>" method="get">
                        <div class="row row-gap-3">
                            <div class="col-md-9">
                                <input type="text" class="form-control ol-form-control" name="search" value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(get_phrase('Search user')); ?>" />
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn ol-btn-primary w-100" id="submit-button"> <?php echo e(get_phrase('Search')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-md-12">
                    <!-- Table -->
                    <?php if(count($students) > 0): ?>
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($students) . ' ' . get_phrase('of') . ' ' . $students->total() . ' ' . get_phrase('data')); ?>

                            </p>
                        </div>
                        <div class="table-responsive course_list" id="course_list">
                            <table class="table eTable eTable-2 print-table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"><?php echo e(get_phrase('Name')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Phone')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Enrolled Course')); ?></th>
                                        <th class="print-d-none" scope="col"><?php echo e(get_phrase('Options')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row">
                                                <p class="row-number"><?php echo e(++$key); ?></p>
                                            </th>
                                            <td>
                                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                    <div class="dAdmin_profile_img">
                                                        <img class="img-fluid rounded-circle image-45" width="45" height="45" src="<?php echo e(get_image($row->photo)); ?>" />
                                                    </div>
                                                    <div class="ms-1">
                                                        <h4 class="title fs-14px"><?php echo e($row->name); ?></h4>
                                                        <p class="sub-title2 text-12px"><?php echo e($row->email); ?></p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="dAdmin_info_name min-w-150px">
                                                    <p><?php echo e($row->phone); ?></p>
                                                </div>
                                            </td>
                                            <td>
                                                <?php echo e(App\Models\Enrollment::where('user_id', $row->id)->count()); ?>

                                                <?php echo e(get_phrase('Courses')); ?>

                                            </td>
                                            <td class="print-d-none">
                                                <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                    <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <span class="fi-rr-menu-dots-vertical"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('admin.student.edit', $row->id)); ?>"><?php echo e(get_phrase('Edit')); ?></a>
                                                        </li>

                                                        <li>
                                                            <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.student.delete', $row->id)); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Remove account')); ?></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('admin.no_data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <!-- Data info and Pagination -->
                    <?php if(count($students) > 0): ?>
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($students) . ' ' . get_phrase('of') . ' ' . $students->total() . ' ' . get_phrase('data')); ?>

                            </p>
                            <?php echo e($students->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ttelbdtex/public_html/resources/views/admin/student/index.blade.php ENDPATH**/ ?>