<?php $current_route = Route::currentRouteName(); ?>

<div class="sidebar-logo-area">
    <a href="#" class="sidebar-logos">
        <img class="sidebar-logo-lg" height="50px" src="<?php echo e(get_image(get_frontend_settings('dark_logo'))); ?>"
            alt="">
        <img class="sidebar-logo-sm" height="40px" src="<?php echo e(get_image(get_frontend_settings('favicon'))); ?>" alt="">
    </a>
    <button class="sidebar-cross menu-toggler d-block d-lg-none">
        <span class="fi-rr-cross"></span>
    </button>
</div>
<h3 class="sidebar-title fs-12px px-30px pb-20px text-uppercase mt-4"><?php echo e(get_phrase('Main Menu')); ?></h3>
<div class="sidebar-nav-area">
    <nav class="sidebar-nav">
        <ul class="px-14px pb-24px">

            <?php if(has_permission('admin.dashboard')): ?>
                <li class="sidebar-first-li <?php echo e($current_route == 'admin.dashboard' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.dashboard')); ?>">
                        <span class="icon fi-rr-house-blank"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Dashboard')); ?></span>
                        </div>
                    </a>
                </li>
            <?php endif; ?>


            <?php if(has_permission('admin.categories')): ?>
                <li class="sidebar-first-li <?php echo e($current_route == 'admin.categories' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.categories')); ?>">
                        <span class="icon fi-rr-chart-tree-map"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Category')); ?></span>
                        </div>
                    </a>
                </li>
            <?php endif; ?>


            <?php if(has_permission('admin.courses')): ?>
                <li class="sidebar-first-li first-li-have-sub <?php if(
                    $current_route == 'admin.courses' ||
                        $current_route == 'admin.course.create' ||
                        $current_route == 'admin.course.edit' ||
                        $current_route == 'admin.coupons'): ?> active showMenu <?php endif; ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-e-learning"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Course')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Course')); ?></li>
                        <li class="sidebar-second-li <?php if($current_route == 'admin.courses' || $current_route == 'admin.course.edit'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('admin.courses')); ?>"><?php echo e(get_phrase('Manage Courses')); ?></a>
                        </li>
                        <li class="sidebar-second-li <?php if($current_route == 'admin.course.create'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('admin.course.create')); ?>"><?php echo e(get_phrase('Add New Course')); ?></a>
                        </li>
                        <li class="sidebar-second-li <?php if($current_route == 'admin.coupons'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('admin.coupons')); ?>"><?php echo e(get_phrase('Coupons')); ?></a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.bootcamps')): ?>
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.bootcamps' || $current_route == 'admin.bootcamp.create' || $current_route == 'admin.bootcamp.edit' || $current_route == 'admin.bootcamp.purchase.history' || $current_route == 'admin.bootcamp.purchase.invoice' || $current_route == 'admin.bootcamp.categories' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-sr-users-alt"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Bootcamp')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Bootcamp')); ?></li>

                        <li class="sidebar-second-li <?php if(($current_route == 'admin.bootcamps' || $current_route == 'admin.bootcamp.edit') && request('type') == ''): ?> active <?php endif; ?>"><a
                                href="<?php echo e(route('admin.bootcamps')); ?>"><?php echo e(get_phrase('Manage Bootcamps')); ?></a></li>
                        <li class="sidebar-second-li <?php if($current_route == 'admin.bootcamp.create'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('admin.bootcamp.create')); ?>"><?php echo e(get_phrase('Add New Bootcamp')); ?></a>
                        </li>
                        <li
                            class="sidebar-second-li <?php echo e($current_route == 'admin.bootcamp.purchase.history' || $current_route == 'admin.bootcamp.purchase.invoice' ? 'active' : ''); ?>">
                            <a
                                href="<?php echo e(route('admin.bootcamp.purchase.history')); ?>"><?php echo e(get_phrase('Purchase History')); ?></a>
                        </li>
                        <li
                            class="sidebar-second-li <?php echo e($current_route == 'admin.bootcamp.categories' ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.bootcamp.categories')); ?>"><?php echo e(get_phrase('Category')); ?></a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>

            

            <?php if(has_permission('admin.tutor_categories')): ?>
                <li
                    class="sidebar-first-li first-li-have-sub <?php if($current_route == 'admin.tutor_subjects' || $current_route == 'admin.tutor_categories'): ?> active showMenu <?php endif; ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-document-signed"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Tutor Booking')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Tutor Booking')); ?></li>
                        <li class="sidebar-second-li <?php if($current_route == 'admin.tutor_subjects'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('admin.tutor_subjects')); ?>"><?php echo e(get_phrase('Subjects')); ?></a>
                        </li>
                        <li class="sidebar-second-li <?php if($current_route == 'admin.tutor_categories'): ?> active <?php endif; ?>">
                            <a href="<?php echo e(route('admin.tutor_categories')); ?>"><?php echo e(get_phrase('Subject Category')); ?></a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.enroll.history') || has_permission('admin.student.enroll')): ?>
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.student.enroll' || $current_route == 'admin.enroll.history' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi-rr-elevator"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Student enrollment')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Course enrollment')); ?></li>

                        <?php if(has_permission('admin.enroll.history')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.enroll.history' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.enroll.history')); ?>"><?php echo e(get_phrase('Enrollment History')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(has_permission('admin.student.enroll')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.student.enroll' ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.student.enroll')); ?>"><?php echo e(get_phrase('Enroll student')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>


            <?php if(has_permission('admin.offline.payments') ||
                    has_permission('admin.revenue') ||
                    has_permission('admin.instructor.revenue') ||
                    has_permission('admin.purchase.history')): ?>
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.offline.payments' || $current_route == 'admin.revenue' || $current_route == 'admin.instructor.revenue' || $current_route == 'admin.purchase.history' || $current_route == 'admin.purchase.history.invoice' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi-rr-comment-dollar"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Payment Report')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Payment Report')); ?></li>

                        <?php if(has_permission('admin.offline.payments')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.offline.payments' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.offline.payments')); ?>"><?php echo e(get_phrase('Offline payments')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(has_permission('admin.revenue')): ?>
                            <li class="sidebar-second-li <?php echo e($current_route == 'admin.revenue' ? 'active' : ''); ?>"><a
                                    href="<?php echo e(route('admin.revenue')); ?>"><?php echo e(get_phrase('Admin Revenue')); ?></a></li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.instructor.revenue')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.instructor.revenue' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.instructor.revenue')); ?>"><?php echo e(get_phrase('Instructor Revenue')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.purchase.history')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.purchase.history' || $current_route == 'admin.purchase.history.invoice' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.purchase.history')); ?>"><?php echo e(get_phrase('Payment History')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.admins.index') ||
                    has_permission('admin.instructor.index') ||
                    has_permission('admin.student.index')): ?>
                <li class="sidebar-first-li first-li-have-sub <?php if(
                    $current_route == 'admin.instructor.index' ||
                        $current_route == 'admin.instructor.create' ||
                        $current_route == 'admin.instructor.edit' ||
                        $current_route == 'admin.instructor.payout' ||
                        $current_route == 'admin.instructor.payout.filter' ||
                        $current_route == 'admin.instructor.setting' ||
                        $current_route == 'admin.instructor.application' ||
                        $current_route == 'admin.admins.index' ||
                        $current_route == 'admin.admins.create' ||
                        $current_route == 'admin.admins.edit' ||
                        $current_route == 'admin.admins.permission' ||
                        $current_route == 'admin.student.index' ||
                        $current_route == 'admin.student.edit' ||
                        $current_route == 'admin.student.create'): ?> active <?php endif; ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi-rr-users"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Users')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Users')); ?></li>
                        <?php if(has_permission('admin.admins.index')): ?>
                            <li
                                class="sidebar-second-li second-li-have-sub <?php if(
                                    $current_route == 'admin.admins.index' ||
                                        $current_route == 'admin.admins.create' ||
                                        $current_route == 'admin.admins.edit' ||
                                        $current_route == 'admin.admins.permission'): ?> active <?php endif; ?>">
                                <a href="javascript:void(0);"><?php echo e(get_phrase('Admin')); ?></a>
                                <ul class="second-sub-menu">
                                    <li class="sidebar-third-li <?php if(
                                        $current_route == 'admin.admins.index' ||
                                            $current_route == 'admin.admins.permission' ||
                                            $current_route == 'admin.admins.edit'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.admins.index')); ?>"><?php echo e(get_phrase('Manage Admin')); ?></a>
                                    </li>
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.admins.create'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.admins.create')); ?>"><?php echo e(get_phrase('Add New Admin')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if(has_permission('admin.instructor.index')): ?>
                            <li
                                class="sidebar-second-li second-li-have-sub <?php if(
                                    $current_route == 'admin.instructor.index' ||
                                        $current_route == 'admin.instructor.create' ||
                                        $current_route == 'admin.instructor.edit' ||
                                        $current_route == 'admin.instructor.payout' ||
                                        $current_route == 'admin.instructor.payout.filter' ||
                                        $current_route == 'admin.instructor.setting' ||
                                        $current_route == 'admin.instructor.application'): ?> active <?php endif; ?>">
                                <a href="javascript:void(0);"><?php echo e(get_phrase('Instructor')); ?></a>
                                <ul class="second-sub-menu">
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.instructor.index' || $current_route == 'admin.instructor.edit'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.instructor.index')); ?>"><?php echo e(get_phrase('Manage Instructors')); ?></a>
                                    </li>
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.instructor.create'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.instructor.create')); ?>"><?php echo e(get_phrase('Add new Instructor')); ?></a>
                                    </li>
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.instructor.payout' || $current_route == 'admin.instructor.payout.filter'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.instructor.payout')); ?>"><?php echo e(get_phrase('Instructor Payout')); ?></a>
                                    </li>
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.instructor.setting'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.instructor.setting')); ?>"><?php echo e(get_phrase('Instructor Setting')); ?></a>
                                    </li>
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.instructor.application'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.instructor.application')); ?>"><?php echo e(get_phrase('Application')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.student.index')): ?>
                            <li
                                class="sidebar-second-li second-li-have-sub <?php if(
                                    $current_route == 'admin.student.index' ||
                                        $current_route == 'admin.student.edit' ||
                                        $current_route == 'admin.student.create'): ?> active <?php endif; ?>">
                                <a href="javascript:void(0);"><?php echo e(get_phrase('Student')); ?></a>
                                <ul class="second-sub-menu">
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.student.index' || $current_route == 'admin.student.edit'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.student.index')); ?>"><?php echo e(get_phrase('Manage Students')); ?></a>
                                    </li>
                                    <li class="sidebar-third-li <?php if($current_route == 'admin.student.create'): ?> active <?php endif; ?>">
                                        <a
                                            href="<?php echo e(route('admin.student.create')); ?>"><?php echo e(get_phrase('Add new Student')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.message')): ?>
                <li class="sidebar-first-li <?php echo e($current_route == 'admin.message' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.message')); ?>">
                        <span class="icon fi-rr-messages"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Message')); ?></span>
                        </div>
                        <?php if(
                            $unread_msg =
                                App\Models\Message::where('receiver_id', auth()->user()->id)->where('read', '')->count() > 0): ?>
                            <span class="d-inline-block mt-2px badge bg-danger ms-auto"><?php echo e($unread_msg); ?></span>
                        <?php endif; ?>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.newsletter')): ?>
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.newsletter' || $current_route == 'admin.subscribed_user' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-envelope-open-text"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Newsletter')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Newsletter')); ?></li>

                        <li class="sidebar-second-li <?php echo e($current_route == 'admin.newsletter' ? 'active' : ''); ?>"><a
                                href="<?php echo e(route('admin.newsletter')); ?>"><?php echo e(get_phrase('Manage Newsletters')); ?></a>
                        </li>
                        <li class="sidebar-second-li <?php echo e($current_route == 'admin.subscribed_user' ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('admin.subscribed_user')); ?>"><?php echo e(get_phrase('Subscribed User')); ?></a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.contacts')): ?>
                <li class="sidebar-first-li <?php echo e($current_route == 'admin.contacts' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.contacts')); ?>">
                        <span class="icon fi fi-br-portrait"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Contacts')); ?></span>
                        </div>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.blogs') ||
                    has_permission('admin.blog.pending') ||
                    has_permission('admin.blog.category') ||
                    has_permission('admin.blog.category')): ?>
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.blogs' || $current_route == 'admin.blog.create' || $current_route == 'admin.blog.edit' || $current_route == 'admin.blog.pending' || $current_route == 'admin.blog.category' || $current_route == 'admin.blog.settings' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-blog-text"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Blogs')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('Blogs')); ?></li>
                        <?php if(has_permission('admin.blogs')): ?>
                            <li class="sidebar-second-li <?php echo e($current_route == 'admin.blogs' ? 'active' : ''); ?>"><a
                                    href="<?php echo e(route('admin.blogs')); ?>"><?php echo e(get_phrase('Manage Blogs')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.blog.pending')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.blog.pending' ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.blog.pending')); ?>"><?php echo e(get_phrase('Pending Blogs')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.blog.category')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.blog.category' ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.blog.category')); ?>"><?php echo e(get_phrase('Category')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.blog.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.blog.settings' ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.blog.settings')); ?>"><?php echo e(get_phrase('Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(has_permission('admin.knowledge.base')): ?>
                <li class="sidebar-first-li <?php echo e($current_route == 'admin.knowledge.base' || $current_route == 'admin.articles' || $current_route == 'admin.articles.create' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.knowledge.base')); ?>">
                        <span class="icon fi-rr-brain"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('Knowledge Base')); ?></span>
                        </div>
                        <?php if(
                            $unread_msg =
                                App\Models\Message::where('receiver_id', auth()->user()->id)->where('read', '')->count() > 0): ?>
                            <span class="d-inline-block mt-2px badge bg-danger ms-auto"><?php echo e($unread_msg); ?></span>
                        <?php endif; ?>
                    </a>
                </li>
            <?php endif; ?>
            
        </ul>
    </nav>



    <?php if(has_permission('admin.system.settings') ||
            has_permission('admin.website.settings') ||
            has_permission('admin.payment.settings') ||
            has_permission('admin.manage.language') ||
            has_permission('admin.notification.settings') ||
            has_permission('admin.live.class.settings') ||
            has_permission('admin.certificate.settings') ||
            has_permission('admin.player.settings') ||
            has_permission('admin.open.ai.settings') ||
            has_permission('admin.pages') ||
            has_permission('admin.seo.settings') ||
            has_permission('admin.about')): ?>
        <nav class="sidebar-nav">
            <h3 class="sidebar-title fs-12px px-30px text-uppercase pb-3"><?php echo e(get_phrase('Settings')); ?></h3>
            <ul class="px-14px pb-24px mb-5 pb-5">
                <li
                    class="sidebar-first-li first-li-have-sub <?php echo e($current_route == 'admin.system.settings' || $current_route == 'admin.website.settings' || $current_route == 'admin.language.phrase.edit' || $current_route == 'admin.payment.settings' || $current_route == 'admin.manage.language' || $current_route == 'admin.notification.settings' || $current_route == 'admin.live.class.settings' || $current_route == 'admin.live.class.settings' || $current_route == 'admin.certificate.settings' || $current_route == 'admin.player.settings' || $current_route == 'admin.open.ai.settings' || $current_route == 'admin.pages' || $current_route == 'admin.seo.settings' || $current_route == 'admin.about' ? 'active' : ''); ?>">
                    <a href="javascript:void(0);">
                        <span class="icon fi fi-rr-settings"></span>
                        <div class="text">
                            <span><?php echo e(get_phrase('System Settings')); ?></span>
                        </div>
                    </a>
                    <ul class="first-sub-menu">
                        <li class="first-sub-menu-title fs-14px mb-18px"><?php echo e(get_phrase('System Settings')); ?></li>
                        <?php if(has_permission('admin.system.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.system.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.system.settings')); ?>"><?php echo e(get_phrase('System Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.website.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.website.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.website.settings')); ?>"><?php echo e(get_phrase('Website Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.payment.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.payment.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.payment.settings')); ?>"><?php echo e(get_phrase('Payment Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.manage.language')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.manage.language' || $current_route == 'admin.language.phrase.edit' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.manage.language')); ?>"><?php echo e(get_phrase('Manage Language')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.live.class.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.live.class.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.live.class.settings')); ?>"><?php echo e(get_phrase('Live Class Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.notification.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.notification.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.notification.settings')); ?>"><?php echo e(get_phrase('SMTP Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.certificate.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.certificate.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.certificate.settings')); ?>"><?php echo e(get_phrase('Certificate Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.player.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.player.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.player.settings')); ?>"><?php echo e(get_phrase('Player Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.open.ai.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.open.ai.settings' ? 'active' : ''); ?>">
                                <a
                                    href="<?php echo e(route('admin.open.ai.settings')); ?>"><?php echo e(get_phrase('Open AI Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.pages')): ?>
                            <li class="sidebar-second-li <?php echo e($current_route == 'admin.pages' ? 'active' : ''); ?>"><a
                                    href="<?php echo e(route('admin.pages')); ?>"><?php echo e(get_phrase('Home Page Builder')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.seo.settings')): ?>
                            <li
                                class="sidebar-second-li <?php echo e($current_route == 'admin.seo.settings' ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('admin.seo.settings')); ?>"><?php echo e(get_phrase('SEO Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(has_permission('admin.about')): ?>
                            <li class="sidebar-second-li <?php echo e($current_route == 'admin.about' ? 'active' : ''); ?>"><a
                                    href="<?php echo e(route('admin.about')); ?>"><?php echo e(get_phrase('About')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </li>

                <?php if(has_permission('admin.manage.profile')): ?>
                    <li class="sidebar-first-li <?php echo e($current_route == 'admin.manage.profile' ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.manage.profile')); ?>">
                            <span class="icon fi-rr-circle-user"></span>
                            <div class="text">
                                <span><?php echo e(get_phrase('Manage Profile')); ?></span>
                            </div>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    <?php endif; ?>
</div>

<script>
    "use strict";
    document.addEventListener("DOMContentLoaded", function() {
        // Restore scroll position if it exists in localStorage
        const scrollPos = localStorage.getItem('navScrollPos');
        const sidebarNavArea = document.querySelector('.sidebar-nav-area');
        if (scrollPos) {
            sidebarNavArea.scrollTop = scrollPos;
        }

        // Ensure the active element is visible
        const activeElement = document.querySelector('.sidebar-nav-area .active');
        if (activeElement) {
            const activeElementTop = activeElement.getBoundingClientRect().top;
            const navAreaTop = sidebarNavArea.getBoundingClientRect().top;
            const navAreaBottom = navAreaTop + sidebarNavArea.clientHeight;

            if (activeElementTop < navAreaTop || activeElementTop > navAreaBottom) {
                sidebarNavArea.scrollTop = activeElement.offsetTop - sidebarNavArea.offsetTop;
            }
        }

        // Save scroll position before page unload
        window.addEventListener('beforeunload', function() {
            localStorage.setItem('navScrollPos', sidebarNavArea.scrollTop);
        });
    });
</script>
<?php /**PATH /home/ttelbdtex/public_html/resources/views/admin/navigation.blade.php ENDPATH**/ ?>